### 55.1.1. 推断"grab"依赖

标准的Groovy包含一个`@Grab`注解，它允许你声明对第三方库的依赖。这项有用的技术允许Groovy以和Maven或Gradle相同的方式下载jars，但不需要使用构建工具。

Spring Boot进一步延伸了该技术，它会基于你的代码尝试推导你"grab"哪个库。例如，由于WebApplication代码上使用了`@RestController`注解，"Tomcat"和"Spring MVC"将被获取（grabbed）。

下面items被用作"grab hints"：

|items|Grabs|
|-----|:-----|
|JdbcTemplate,NamedParameterJdbcTemplate,DataSource|JDBC应用|
|@EnableJms|JMS应用|
|@EnableCaching|Caching abstraction|
|@Test|JUnit|
|@EnableRabbit|RabbitMQ|
|@EnableReactor|Project Reactor|
|继承Specification|Spock test|
|@EnableBatchProcessing|Spring Batch|
|@MessageEndpoint,@EnableIntegrationPatterns|Spring Integration|
|@EnableDeviceResolver|Spring Mobile|
|@Controller,@RestController,@EnableWebMvc|Spring MVC + Embedded Tomcat|
|@EnableWebSecurity|Spring Security|
|@EnableTransactionManagement|Spring Transaction Management|

**注**：想要理解自定义是如何生效，可以查看Spring Boot CLI源码中的[CompilerAutoConfiguration](http://github.com/spring-projects/spring-boot/tree/master/spring-boot-cli/src/main/java/org/springframework/boot/cli/compiler/CompilerAutoConfiguration.java)子类。
